﻿<%@ Page Title="Patients" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="Patients.aspx.cs" Inherits="Patients" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ Register src="controls/ErrorList.ascx" tagname="ErrorList" tagprefix="uc1" %>
<%@ Register src="controls/Date.ascx" tagname="Date" tagprefix="uc2" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <style type="text/css">
        .style1
        {
            width: 100%;
        }
        .style2
        {
            width: 110px;
        }
        .style3
        {
        }
        .style4
        {
            width: 8px;
        }
        .style6
        {
            width: 110px;
        }
        .style8
        {
            width: 200px;
        }
        .style9
        {
            width: 100px;
        }
        .style10
        {
            width: 110px;
        }
        .style11
        {
            width: 250px;
        }
        .style12
        {
            width: 250px;
        }
        .style13
        {
            width: 200px;
        }
        .style14
        {
            width: 120px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <asp:ValidationSummary ID="ValidationSummaryPatientsOnSearch"  runat="server"
        TabIndex="1" 
        ValidationGroup="OnSearch"
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ShowMessageBox="True" />
    
    <asp:Panel ID="PanelObjectContent" runat="server">
   
        <br />
        <uc1:ErrorList ID="ErrorList1" runat="server" />
        <br />
        <div class = "excludeSaveWarnings">
        <asp:Panel ID="PanelSelectPatient" runat="server" GroupingText="Lookup Patient&nbsp;&nbsp;" Width="65%">
            <br />
            <asp:Label ID="LabelforTextBoxSSNSearch" runat="server" AssociatedControlID="TextBoxSSNSearch">SSN:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxSSNSearch" runat="server"
                TabIndex="5" MaxLength = "12"> 
            </asp:TextBox>
            <asp:RegularExpressionValidator ID="RegularExpressionValidatorSSNSearch" runat="server" 
                TabIndex="6" 
                ControlToValidate="TextBoxSSNSearch" 
                ErrorMessage="SSN needs to be in the following format (dashes optional): XXX-XX-XXXX.  Include a 'P' or 'p' at the end for pseudo SSN’s."
                SetFocusOnError="true" 
                ValidationGroup="OnSearch"
                ValidationExpression="^\s*\d{3}-?\d{2}-?\d{4}[pP]?\s*$"
                Display="Static"></asp:RegularExpressionValidator>         
            <br />
            <br />
            <asp:Label ID="LabelforTextBoxPatientNameSearch" runat="server" AssociatedControlID="TextBoxPatientNameSearch">Patient Last Name:</asp:Label>
            <br />
            <asp:TextBox ID="TextBoxPatientNameSearch" runat="server" 
                TabIndex="7"> 
            </asp:TextBox>
            <br />
            <br />
            <asp:Label ID="LabelForScreeningDateFrom" runat="server" 
                AssociatedControlID="ScreeningDateFrom:TextBoxDate" Text="Screening Date From (mm/dd/yyyy):"></asp:Label>
            
            <uc2:Date ID="ScreeningDateFrom" runat="server" ValidationGroup="OnSearch" CustomValidatorValidationGroup="OnSearch" 
                ErrorMessage="Screening Date From must be in format (mm/dd/yyyy)." />
                         
            <asp:Label ID="LabelForScreeningDateTo" runat="server" 
                AssociatedControlID="ScreeningDateTo:TextBoxDate" Text="Screening Date To (mm/dd/yyyy):"></asp:Label>
            <uc2:Date ID="ScreeningDateTo" runat="server" ValidationGroup="OnSearch" CustomValidatorValidationGroup="OnSearch"
                ErrorMessage="Screening Date To must be in format (mm/dd/yyyy)." />
            <asp:CompareValidator ID = "ScreeningDateValidator" runat = "server" ControlToValidate = "ScreeningDateTo:TextBoxDate" 
                ControlToCompare = "ScreeningDateFrom:TextBoxDate" Operator = "GreaterThanEqual" Type = "Date" ValidationGroup="OnSearch"
                ErrorMessage="Screening Date To must be later than or equal to Screening Date From" EnableClientScript = "true" Display = "Static" ></asp:CompareValidator> 
            <br />
            <asp:Label ID="LabelVisn" runat="server" Text="VISN:" Font-Bold="true" AssociatedControlID="DropDownListVISN"></asp:Label>
            <br />
            <asp:DropDownList ID="DropDownListVISN" runat="server" 
                AppendDataBoundItems="true"  
                DataSourceID="ObjectDataSourceVISN" 
                AutoPostBack="true"
                DataTextField="NAME" 
                DataValueField="ID" 
                onselectedindexchanged="DropDownListVISN_SelectedIndexChanged">
                <asp:ListItem Value="0">-- Select a Value --</asp:ListItem>
            </asp:DropDownList>
            <br />
            <br />
            <asp:Label ID="LabelStation" runat="server" Text="Station:" Font-Bold="true" AssociatedControlID="DropDownListStation"></asp:Label>
            <br />
            <asp:DropDownList ID="DropDownListStation" runat="server" 
                AppendDataBoundItems="true"  
                DataSourceID="ObjectDataSourceStation" 
                DataTextField="FullStationName"
                DataValueField="ID">
                <asp:ListItem Value="0">-- Select a Value --</asp:ListItem>
            </asp:DropDownList>
            <br />
            <br />
            <asp:Label ID="LabelStatus" runat="server" Text="Status:" Font-Bold="true" AssociatedControlID="DropDownListStatus"></asp:Label>
            <br />
            <asp:DropDownList ID="DropDownListStatus" runat="server" 
                AppendDataBoundItems="true"  
                DataSourceID="ObjectDataSourceStatus" 
                DataTextField="NAME"
                DataValueField="ID">
                <asp:ListItem Value="0">-- Select a Value --</asp:ListItem>
            </asp:DropDownList>
            <br />
            <br />
            <asp:Button ID="ButtonSearchPatient" runat="server" 
                ValidationGroup="OnSearch"
                TabIndex="8" 
                Text="  Search  " 
                onclick="ButtonSearchPatient_Click" />
            <br /><br />
            
            <asp:ObjectDataSource ID="ObjectDataSourceVISN" runat="server" 
                SelectMethod="GetTBIRolesPermittedVAMCList" 
                TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
            </asp:ObjectDataSource>
            <asp:ObjectDataSource ID="ObjectDataSourceStatus" runat="server" 
                SelectMethod="GetTBIReferralStatusList" 
                TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
            </asp:ObjectDataSource>
            <asp:ObjectDataSource ID="ObjectDataSourceStation" runat="server" 
                SelectMethod="GetTBIRolesPermittedStationsPerVISN" 
                TypeName="VeteransAffairs.Registries.BusinessManager.Utilities.DropDownLists">
                <SelectParameters>
                    <asp:ControlParameter 
                            ControlID="DropDownListVISN" 
                            ConvertEmptyStringToNull="true" 
                            DefaultValue="0" Name="VisnId"/>
                </SelectParameters>
            </asp:ObjectDataSource>
            
            <asp:GridView ID="GridViewPatients" runat="server" Visible="False"
                TabIndex="9" 
                DataKeyNames="PATIENT_ID"
                AutoGenerateColumns="False" Width="100%"
                DataSourceID="ObjectDataSourceCriteriaSearch"
                AllowPaging="True" 
                AllowSorting="True">
            <Columns>
                
                <asp:HyperLinkField DataNavigateUrlFields="PATIENT_ID" SortExpression="PATIENT_ID" NavigateUrl="~/Patients.aspx"
                            ItemStyle-HorizontalAlign="Center" HeaderStyle-HorizontalAlign="Center"
                            DataNavigateUrlFormatString="Patients.aspx?id={0}"
                            Text=" View " ShowHeader="false">
                            <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center" Width="18px"></ItemStyle>
                </asp:HyperLinkField>

                <asp:BoundField DataField="Snum" HeaderText="SSN" 
                    SortExpression="Snum" >
                    <ItemStyle HorizontalAlign="Center" />
                </asp:BoundField>
                
                <asp:BoundField DataField="FullName" HeaderText="Full Name" 
                    SortExpression="LAST_NAME" >
                    <ItemStyle HorizontalAlign="Center" />
                </asp:BoundField>

                
                
                <asp:TemplateField HeaderText="Service Branch" SortExpression="STD_SERVICEBRANCH.NAME">
                    <ItemStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelServiceBranch" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_SERVICEBRANCH.NAME")))%>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

            </Columns>
            </asp:GridView>
            <br />
            <asp:ObjectDataSource ID="ObjectDataSourceCriteriaSearch" runat="server" 
                SelectMethod="SelectCriteriaSearch" 
                SelectCountMethod="SelectCriteriaSearchCount" 
                StartRowIndexParameterName="startRow" 
                MaximumRowsParameterName="maxRows" 
                SortParameterName="sort"
                EnablePaging="True"   
                TypeName="VeteransAffairs.Registries.BusinessManager.PatientManager"
                DataObjectTypeName="VeteransAffairs.Registries.Business.PATIENT">
                <SelectParameters>
                    <asp:ControlParameter ControlID="TextBoxPatientNameSearch" 
                         Direction="Input" Name="lastName" Type="String"/>
                    <asp:ControlParameter ControlID="TextBoxSSNSearch" 
                         Direction="Input" Name="snum" Type="String"/>
                    <asp:ControlParameter Type = "String" ControlID = "ScreeningDateFrom"
                         Direction = "Input" Name = "fromDate" PropertyName = "DateValue"/>
                    <asp:ControlParameter Type = "String" ControlID = "ScreeningDateTo"
                         Direction = "Input" Name = "toDate" PropertyName = "DateValue"/>
                    <asp:ControlParameter Type = "String" ControlID = "DropDownListVISN" Direction = "Input"
                        PropertyName = "SelectedValue" Name = "visn" />
                    <asp:ControlParameter Type = "String" ControlID = "DropDownListStation" PropertyName = "SelectedValue"
                        Name = "station" Direction = "Input" />
                    <asp:ControlParameter Type = "String" ControlID = "DropDownListStatus" PropertyName = "SelectedValue"
                         Direction = "Input" Name = "status" />
                    <asp:Parameter DefaultValue = "true" Type = "Boolean" Name = "searchReferrals" />       
                    <asp:Parameter Name="sort" Type="String" />
                    <asp:Parameter Name="startRow" Type="Int32" />
                    <asp:Parameter Name="maxRows" Type="Int32" />
                </SelectParameters>
            </asp:ObjectDataSource>
            
        </asp:Panel>
        </div>
        <asp:Panel ID="PanelPatient" runat="server" GroupingText="Patient Information&nbsp;&nbsp;" Width="65%">
            <asp:FormView ID="FormViewPatient" runat="server" 
                DataSourceID="ObjectDataSourcePatient">
                <ItemTemplate>
                    <table class="style1" >
                        <tr>
                            <td class="style10">
                                <asp:Label ID="LabelforPATIENT_ICNLabel" runat="server" AssociatedControlID="PATIENT_ICNLabel">ICN:</asp:Label>
                                </td>
                            <td style="style11">
                                <asp:Label ID="PATIENT_ICNLabel" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("PATIENT_ICN"))) %>' />
                            </td>
                            <td style="style4">
                                &nbsp;</td>
                            <td class="style2" style="style6">
                                <asp:Label ID="LabelforSSNLabel1" runat="server" AssociatedControlID="SSNLabel1">SSN:</asp:Label>
                                </td>
                            <td style="style8">
                                <asp:Label ID="SSNLabel1" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("Snum"))) %>' />
                            </td>
                        </tr>
                    </table>
                    <hr />
                    <table class="style1" >
                        <tr>
                            <td class="style2">
                                <asp:Label ID="LabelforFullNameLabel" runat="server" AssociatedControlID="FullNameLabel">Full Name:</asp:Label>
                                </td>
                            <td class="style3">
                                <asp:Label ID="FullNameLabel" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("FullName"))) %>' />
                            </td>
                            <td class="style3">
                                &nbsp;</td>
                            <td class="style3">
                                &nbsp;</td>
                            <td class="style3">
                                &nbsp;</td>
                        </tr>
                        <tr>
                            <td class="style2">
                                <asp:Label ID="LabelforSTD_INSTITUTION_IDLabel" runat="server" AssociatedControlID="STD_INSTITUTION_IDLabel">Home VAMC:</asp:Label>
                                </td>
                            <td colspan="4">
                                <asp:Label ID="STD_INSTITUTION_IDLabel" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION.FullVisnName"))) %>' />
                            </td>
                        </tr>
                    </table>
                    <table class="style1" >
                        <tr>
                            <td class="style10">
                                <asp:Label ID="LabelforSTD_GENDER_IDLabel" runat="server" AssociatedControlID="STD_GENDER_IDLabel">Gender:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label ID="STD_GENDER_IDLabel" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_GENDER.NAME"))) %>' />
                                
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style6">
                                <asp:Label ID="LabelforBIRTH_DATELabel" runat="server" AssociatedControlID="BIRTH_DATELabel">Birth Date:</asp:Label>
                                </td>
                            <td class="style8">
                                <asp:Label ID="BIRTH_DATELabel" runat="server" 
                                    Text='<%# String.Format("{0:d}", AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("BIRTH_DATE")))) %>' />
                            </td>
                        </tr>
                        <tr>
                            <td class="style10">
                                <asp:Label ID="LabelforSTD_RACE_IDLabel" runat="server" 
                                    AssociatedControlID="STD_RACE_IDLabel">Race:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label ID="STD_RACE_IDLabel" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_RACE.NAME"))) %>' />
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style6">
                                <asp:Label ID="LabelforDEATH_DATELabel" runat="server" AssociatedControlID="DEATH_DATELabel">Death Date:</asp:Label>
                                </td>
                            <td class="style8">
                                <asp:Label ID="DEATH_DATELabel" runat="server" 
                                    Text='<%# String.Format("{0:d}", AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("DEATH_DATE")))) %>' />
                            </td>
                        </tr>
                        <tr>
                            <td class="style10">
                                <asp:Label ID="LabelforSTD_MARITALSTATUS_IDLabel" runat="server" 
                                    AssociatedControlID="STD_MARITALSTATUS_IDLabel">Marital Status:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label ID="STD_MARITALSTATUS_IDLabel" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_MARITALSTATUS.NAME"))) %>' />
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style6">
                                <asp:Label ID="LabelforSTD_ETHNICITY_IDLabel" runat="server" AssociatedControlID="STD_ETHNICITY_IDLabel">Ethnicity:</asp:Label>
                                </td>
                            <td class="style8">
                                <asp:Label ID="STD_ETHNICITY_IDLabel" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_ETHNICITY.NAME"))) %>' />
                            </td>
                        </tr>
                        <tr>
                            <td class="style10">
                                <asp:Label ID="LabelforADDRESS_LINE1Label" runat="server" AssociatedControlID="ADDRESS_LINE1Label">Address:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label ID="ADDRESS_LINE1Label" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("ADDRESS_LINE1"))) %>' />
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style6">
                                <asp:Label ID="LabelforCITYLabel" runat="server" AssociatedControlID="CITYLabel">City:</asp:Label>
                                </td>
                            <td class="style8">
                                <asp:Label ID="CITYLabel" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("CITY"))) %>' />
                            </td>
                        </tr>
                        <tr>
                            <td class="style10">
                                <asp:Label ID="LabelforADDRESS_LINE2Label" runat="server" AssociatedControlID="ADDRESS_LINE2Label">Address Line 3:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label ID="ADDRESS_LINE2Label" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("ADDRESS_LINE2"))) %>' />
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style6">
                                <asp:Label ID="LabelforSTATELabel" runat="server" AssociatedControlID="STATELabel">Postal Code:</asp:Label>
                                </td>
                            <td class="style8">
                                <asp:Label ID="STATELabel" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STATE"))) %>' />
                            </td>
                        </tr>
                        <tr>
                            <td class="style10">
                                <asp:Label ID="LabelforADDRESS_LINE3Label" runat="server" AssociatedControlID="ADDRESS_LINE3Label">Address Line 2:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label ID="ADDRESS_LINE3Label" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("ADDRESS_LINE3"))) %>' />
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style6">
                                <asp:Label ID="LabelforPOSTAL_CODELabel" runat="server" AssociatedControlID="POSTAL_CODELabel">State:</asp:Label>
                                </td>
                            <td class="style8">
                                <asp:Label ID="POSTAL_CODELabel" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("POSTAL_CODE"))) %>' />
                            </td>
                        </tr>
                        <tr>
                            <td class="style10">
                                <asp:Label ID="LabelforCOUNTYLabel" runat="server" AssociatedControlID="COUNTYLabel">County:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label ID="COUNTYLabel" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("COUNTY"))) %>' />
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style6">
                                <asp:Label ID="LabelforCOUNTRYLabel" runat="server" AssociatedControlID="COUNTRYLabel">Country:</asp:Label>
                                </td>
                            <td class="style8">
                                <asp:Label ID="COUNTRYLabel" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("COUNTRY"))) %>' />
                            </td>
                        </tr>
                    </table>
                    <hr />
                    <table class="style1" >
                        <tr>
                            <td class="style10">
                                <asp:Label ID="LabelforHOME_PHONELabel" runat="server" AssociatedControlID="HOME_PHONELabel">Home Phone:</asp:Label>
                                </td>
                            <td class="style11">
                                <asp:Label ID="HOME_PHONELabel" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("HOME_PHONE"))) %>' />
                            </td>
                            <td class="style4">
                            </td>
                            <td class="style8">
                                <asp:Label ID="LabelforWORK_PHONELabel" runat="server" AssociatedControlID="WORK_PHONELabel">Work Phone:</asp:Label>
                                </td>
                            <td class="style8">
                                <asp:Label ID="WORK_PHONELabel" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("WORK_PHONE"))) %>' />
                            </td>
                        </tr>
                        <tr>
                            <td class="style10">
                                <asp:Label ID="LabelforEMAIL_ADDRESSLabel" runat="server" AssociatedControlID="EMAIL_ADDRESSLabel">Email Address:</asp:Label>
                                </td>
                            <td colspan="4">
                                <asp:Label ID="EMAIL_ADDRESSLabel" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("EMAIL_ADDRESS"))) %>' />
                            </td>
                        </tr>
                    </table>
                    <hr />
                    <table class="style1" >
                        <tr>
                            <td class="style9">
                                <asp:Label ID="LabelforOEF_OIFCheckBox" runat="server" AssociatedControlID="OEF_OIFCheckBox">OEF / OIF:</asp:Label>
                                </td>
                            <td class="style12">
                                <asp:CheckBox ID="OEF_OIFCheckBox" runat="server" 
                                    Checked='<%# SetOEFOIFCheckboxCheckedStatus(Container.DataItem, "OEF_OIF_IND")%>' />
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style14">
                                &nbsp;</td>
                            <td class="style13">
                                &nbsp;</td>
                        </tr>
                        <tr>
                            <td class="style9">
                                <asp:Label ID="LabelforSTD_SERVICEBRANCH_IDLabel" runat="server" AssociatedControlID="STD_SERVICEBRANCH_IDLabel">Service Branch:</asp:Label>
                                </td>
                            <td class="style12">
                                <asp:Label ID="STD_SERVICEBRANCH_IDLabel" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_SERVICEBRANCH.NAME"))) %>' />
                            </td>
                            <td class="style4">
                                &nbsp;</td>
                            <td class="style14">
                                <asp:Label ID="LabelforSTD_COMBATLOCATION_IDLabel" runat="server" AssociatedControlID="STD_COMBATLOCATION_IDLabel">Combat Location:</asp:Label>
                                </td>
                            <td class="style13">
                                <asp:Label ID="STD_COMBATLOCATION_IDLabel" runat="server" 
                                    Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_COMBATLOCATION.NAME"))) %>' />
                            </td>
                        </tr>
                    </table>
                    <br />
                </ItemTemplate>
            </asp:FormView>
            <asp:GridView ID="GridViewTBIReferrals" runat="server" 
            AutoGenerateColumns="False" Width="99%"
            DataSourceID="ObjectDataSourceTBIReferrals"
            AllowPaging="True" AllowSorting="True">
            <Columns>
                <asp:HyperLinkField DataNavigateUrlFields="REFERRAL_ID" 
                     ItemStyle-HorizontalAlign="Center" HeaderStyle-HorizontalAlign="Center"
                DataNavigateUrlFormatString="Referral.aspx?id={0}" ShowHeader="True"
                    Text=" Edit "/>

                <asp:BoundField DataField="REFERRAL_ID" HeaderText="ID" 
                    SortExpression="REFERRAL_ID" >

                <ItemStyle HorizontalAlign="Center" />
                </asp:BoundField>
                
                <asp:TemplateField HeaderText="Screening Date" SortExpression="REFERRAL_DATE">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelReferralDate" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("REFERRAL_DATE","{0:d}"))) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
 
                <asp:TemplateField HeaderText="Status" SortExpression="STD_REFERRALST.NAME">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelStatusName" runat="server" 
                            Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_REFERRALST.NAME"))) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                    
                <asp:HyperLinkField DataNavigateUrlFields="REFERRAL_ID" 
                    ItemStyle-HorizontalAlign="Center"  HeaderStyle-HorizontalAlign="Center"
                DataNavigateUrlFormatString="PatientHealthFactors.aspx?id={0}" ShowHeader="True" HeaderText=" View Patient Health Factors " 
                    Text=" View " />                    
                
            </Columns>
            </asp:GridView>
            
            <asp:ObjectDataSource ID="ObjectDataSourceTBIReferrals" runat="server" 
                SelectMethod="SelectByPatient" 
                SelectCountMethod="SelectByPatientCount" 
                StartRowIndexParameterName="startRow" 
                MaximumRowsParameterName="maxRows" 
                SortParameterName="sort"
                EnablePaging="True"  
                TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIReferralManager"
                >
                <SelectParameters>
                    <asp:ControlParameter ConvertEmptyStringToNull="true" ControlID="HiddenFieldEntryID"  
                        DefaultValue="0" Direction="Input" Name="id" Type="Int32" />
                    <asp:Parameter Name="sort" Type="String" />
                    <asp:Parameter Name="startRow" Type="Int32" />
                    <asp:Parameter Name="maxRows" Type="Int32" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <asp:ObjectDataSource ID="ObjectDataSourcePatient" runat="server" 
                OldValuesParameterFormatString="original_{0}" 
                SelectMethod="SelectByID"
                TypeName="VeteransAffairs.Registries.BusinessManager.PatientManager"
                DataObjectTypeName="VeteransAffairs.Registries.Business.PATIENT">
                <SelectParameters>
                    <asp:QueryStringParameter DefaultValue="0" Name="id" 
                        QueryStringField="id" Type="String" />
                </SelectParameters>
            </asp:ObjectDataSource>
        </asp:Panel>
    </asp:Panel>
    <asp:Panel ID="PanelNoAccess" runat="server" Visible="false" Width="65%">
            You do not have access to the patient id supplied.
            <br /><br />
            Please contact the Registry Manager to grant access or verify that your permissions are correct.
    </asp:Panel>
    <asp:Panel ID="PanelNoInsertAllowed" runat="server" Visible="false" Width="65%">
            You do not have permission to enter a new patient.
            <br /><br />
            Please contact the Registry Manager to grant access or verify that your permissions are correct.
    </asp:Panel>
    <asp:Panel ID="PanelIdNotFound" runat="server" Visible="false" Width="65%">
            No record found for the patient ID supplied.
            <br />
            <br />
            If you tried accessing using a link within an email or typed the link in the browser, please check the link to ensure you have supplied a correct id.
    </asp:Panel>       
    <asp:HiddenField ID="HiddenFieldEntryID" runat="server"/>
</asp:Content>



